package com.bokesoft.yes.meta.json.soluton;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.solution.MetaSolution;

public class MetaSolutionJSONHandler extends AbstractJSONHandler<MetaSolution,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaSolution meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.SOLUTION_TESTLANG, meta.getTestLang());
		JSONHelper.writeToJSON(json, JSONConstants.SOLUTION_DEFAULTLANG, meta.getDefaultLang());
		JSONHelper.writeToJSON(json, JSONConstants.SOLUTION_ENABLEMULTILANG, meta.isEnableMultiLang());
		
		MetaInplaceToolbarCollection inplaceToolBarCollection = meta.getInplaceToolBarCollection();
		if (inplaceToolBarCollection != null) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, inplaceToolBarCollection);
			JSONHelper.writeToJSON(json, JSONConstants.SOLUTION_INPLACETOOLBARCOLLECTION, array);
		}
	}

	@Override
	public MetaSolution newInstance() {
		return new MetaSolution();
	}

	@Override
	public void fromJSONImpl(MetaSolution meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setTestLang(json.optString(JSONConstants.SOLUTION_TESTLANG));
		meta.setDefaultLang(json.optString(JSONConstants.SOLUTION_DEFAULTLANG));
		meta.setEnableMultiLang(json.optBoolean(JSONConstants.SOLUTION_ENABLEMULTILANG));
		
		JSONArray array = json.optJSONArray(JSONConstants.SOLUTION_INPLACETOOLBARCOLLECTION);
		if( array != null ) {
			List<MetaInplaceToolbar> list = UIJSONHandlerUtil.unbuild(MetaInplaceToolbar.class, array);
			MetaInplaceToolbarCollection collection = new MetaInplaceToolbarCollection();
			collection.addAll(list);
			meta.setInplaceToolBarCollection(collection);
		}
	}

}
