package com.bokesoft.yes.meta.json.soluton;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;

public class MetaParaItemJSONHandler extends AbstractJSONHandler<MetaParaItem, SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaParaItem meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
	}

	@Override
	public MetaParaItem newInstance() {
		return new MetaParaItem();
	}

	@Override
	public void fromJSONImpl(MetaParaItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
	}

}
