package com.bokesoft.yes.meta.json.soluton;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;

public class MetaParaGroupJSONHandler extends AbstractJSONHandler<MetaParaGroup, SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaParaGroup meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONArray array = UIJSONHandlerUtil.buildNoKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public MetaParaGroup newInstance() {
		return new MetaParaGroup();
	}

	@Override
	public void fromJSONImpl(MetaParaGroup meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		for( int i = 0,length = array.length();i < length;i++ ) {
			meta.add(UIJSONHandlerUtil.unbuild(MetaParaItem.class, array.optJSONObject(i)));
		}
	}

}
