package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportCellText;
import com.bokesoft.yigo.meta.report.MetaReportColumnExpand;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;
import com.bokesoft.yigo.meta.report.MetaReportGridCell;
import com.bokesoft.yigo.meta.report.MetaReportRowExpand;
import com.bokesoft.yigo.meta.report.MetaReportRowGroup;
import com.bokesoft.yigo.meta.report.embed.MetaReportChart;

public class MetaReportGridCellJSONHandler extends AbstractJSONHandler<MetaReportGridCell,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportGridCell meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_CONTENTTYPE, meta.getContentType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FIELDKEY, meta.getFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FORMULA, meta.getFormula());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMPL, meta.getImpl());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGENO, meta.getPageNo());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_GROUPTYPE, meta.getGroupType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SORTTYPE, meta.getSortType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISMERGED, meta.isMerged());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISMERGEDHEAD, meta.isMergedHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWSPAN, meta.getMergedRowSpan());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLSPAN, meta.getMergedColumnSpan());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PANDDING, meta.getPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OVERFLOW, meta.getOverflow());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_MERGEDETAIL, meta.isMergeDetail());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_MERGETOPGROUP, meta.isMergeTopGroup());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_MERGEBOTTOMGROUP, meta.isMergeBottomGroup());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ISROWEXPAND, meta.isRowExpand());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ISCOLUMNEXPAND, meta.isColumnExpand());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ISPRIMARY, meta.isPrimary());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FILLEMPTYCONTENT, meta.isFillEmptyContent());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMAGESOURCETYPE, meta.getImageSourceType());
		
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PATH, meta.getPath());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SYSTEMCONTENT, meta.getSystemContent());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ISSUMMARY, meta.isSummary());
		
		MetaReportCellText text = meta.getTextNode();
		if( text != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(text, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_TEXT, o);
		}
		
		MetaReportRowExpand rowExpand = meta.getRowExpand();
		if( rowExpand != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(rowExpand, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_ROWEXPAND, o);
		}
		
		MetaReportRowGroup rowGroup = meta.getRowGroup();
		if( rowGroup != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(rowGroup, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_ROWGROUP, o);
		}
		
		MetaReportColumnExpand columnExpand = meta.getColumnExpand();
		if( columnExpand != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(columnExpand, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_COLUMNEXPAND, o);
		}
		
		MetaReportDisplay display = meta.getDisplay();
		if( display != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(display, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_DISPLAY, o);
		}
		
		MetaReportChart metaChart = meta.getChart();
		if( metaChart != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(metaChart, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_CHART, o);
		}
	}

	@Override
	public MetaReportGridCell newInstance() {
		return new MetaReportGridCell();
	}

	@Override
	public void fromJSONImpl(MetaReportGridCell meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setSourceType(json.optInt(JSONConstants.REPORT_SOURCETYPE));
		meta.setContentType(json.optInt(JSONConstants.REPORT_CONTENTTYPE));
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setFieldKey(json.optString(JSONConstants.COMMON_FIELDKEY));
		meta.setFormula(json.optString(JSONConstants.REPORT_FORMULA));
		meta.setImpl(json.optString(JSONConstants.REPORT_IMPL));
		meta.setPageNo(json.optString(JSONConstants.REPORT_PAGENO));
		meta.setGroupType(json.optInt(JSONConstants.REPORT_GROUPTYPE));
		meta.setSortType(json.optInt(JSONConstants.REPORT_SORTTYPE));
		meta.setMerged(json.optBoolean(JSONConstants.GRID_ISMERGED));
		meta.setMergedHead(json.optBoolean(JSONConstants.GRID_ISMERGEDHEAD));
		meta.setMergedRowSpan(json.optInt(JSONConstants.GRID_ROWSPAN));
		meta.setMergedColumnSpan(json.optInt(JSONConstants.GRID_COLSPAN));
		meta.setPadding(json.optString(JSONConstants.COMMON_PANDDING));
		meta.setOverflow(json.optInt(JSONConstants.COMMON_OVERFLOW));
		meta.setMergeDetail(json.optBoolean(JSONConstants.REPORT_MERGEDETAIL));
		meta.setMergeTopGroup(json.optBoolean(JSONConstants.REPORT_MERGETOPGROUP));
		meta.setMergeBottomGroup(json.optBoolean(JSONConstants.REPORT_MERGEBOTTOMGROUP));
		meta.setIsRowExpand(json.optBoolean(JSONConstants.REPORT_ISROWEXPAND));
		meta.setIsColumnExpand(json.optBoolean(JSONConstants.REPORT_ISCOLUMNEXPAND));
		meta.setPrimary(json.optBoolean(JSONConstants.COMMON_ISPRIMARY));
		meta.setFillEmptyContent(json.optBoolean(JSONConstants.REPORT_FILLEMPTYCONTENT));
		meta.setImageSourceType(json.optInt(JSONConstants.REPORT_IMAGESOURCETYPE));
		meta.setPath(json.optString(JSONConstants.REPORT_PATH));
		meta.setSystemContent(json.optString(JSONConstants.REPORT_SYSTEMCONTENT));
		meta.setSummary(json.optBoolean(JSONConstants.REPORT_ISSUMMARY));
		
		JSONObject o = json.optJSONObject(JSONConstants.REPORT_TEXT);
		if( o != null ) {
			meta.setTextNode(ReportJSONHandlerUtil.unbuild(MetaReportCellText.class, o));
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_ROWEXPAND);
		if( o != null ) {
			meta.setRowExpand(ReportJSONHandlerUtil.unbuild(MetaReportRowExpand.class, o));
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_ROWGROUP);
		if( o != null ) {
			meta.setRowGroup(ReportJSONHandlerUtil.unbuild(MetaReportRowGroup.class, o));
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_COLUMNEXPAND);
		if( o != null ) {
			meta.setColumnExpand(ReportJSONHandlerUtil.unbuild(MetaReportColumnExpand.class, o));
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_DISPLAY);
		if( o != null ) {
			meta.setDisplay(ReportJSONHandlerUtil.unbuild(MetaReportDisplay.class, o));
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_DISPLAY);
		if( o != null ) {
			meta.setChart(ReportJSONHandlerUtil.unbuild(MetaReportChart.class, o));
		}
	}

}
