package com.bokesoft.yes.meta.json.report;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportFormat;
import com.bokesoft.yigo.meta.report.MetaReportListItem;

public class MetaReportFormatJSONHandler extends AbstractJSONHandler<MetaReportFormat,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportFormat meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_TRANSFORMER, meta.getTransformer());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FORMATSTRING, meta.getFormatString());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ITEMKEY, meta.getItemKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FIELDKEYS, meta.getFieldKeys());
		
		List<MetaReportListItem> listItems = meta.getListItems();
		if( listItems != null ) {
			JSONArray array = new JSONArray();
			for( MetaReportListItem item : listItems ) {
				array.put(ReportJSONHandlerUtil.build(item, hook));
			}
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		}
		
	}

	@Override
	public MetaReportFormat newInstance() {
		return new MetaReportFormat();
	}

	@Override
	public void fromJSONImpl(MetaReportFormat meta, JSONObject json) throws Throwable {
		meta.setDataType(json.optInt(JSONConstants.REPORT_DATATYPE));
		meta.setTransformer(json.optString(JSONConstants.REPORT_TRANSFORMER));
		meta.setFormatString(json.optString(JSONConstants.REPORT_FORMATSTRING));
		meta.setItemKey(json.optString(JSONConstants.REPORT_ITEMKEY));
		meta.setFieldKeys(json.optString(JSONConstants.REPORT_FIELDKEYS));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaReportListItem> listItems = new ArrayList<MetaReportListItem>();
			for( int i = 0;i < array.length();i++ ) {
				listItems.add((MetaReportListItem) ReportJSONHandlerUtil.unbuild(MetaReportListItem.class,array.getJSONObject(i)));
			}
			meta.setListItems(listItems);
		}
	}

}
