package com.bokesoft.yes.meta.json.report;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportDataField;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;

public class MetaReportDataTableJSONHandler extends AbstractJSONHandler<MetaReportDataTable,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportDataTable meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_DBTABLEKEY, meta.getDBTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_STATEMENT, meta.getStateument());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FILTER, meta.getFilter());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCETYPE, meta.getSourceType());

		JSONArray array = ReportJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public MetaReportDataTable newInstance() {
		return new MetaReportDataTable();
	}

	@Override
	public void fromJSONImpl(MetaReportDataTable meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setDBTableKey(json.optString(JSONConstants.REPORT_DBTABLEKEY));
		meta.setStateument(json.optString(JSONConstants.REPORT_STATEMENT));
		meta.setFilter(json.optString(JSONConstants.REPORT_FILTER));
		meta.setSourceType(json.optInt(JSONConstants.REPORT_SOURCETYPE));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		List<MetaReportDataField> list = ReportJSONHandlerUtil.unbuild(MetaReportDataField.class, array);
		
		meta.addAll(list);
	}

}
