package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;

public class MetaLinearLayoutJSONHandler extends MetaComponentLayoutJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaLinearLayout layout = (MetaLinearLayout)meta;
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_ORIENTATION, layout.getOrientation());
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaLinearLayout layout = (MetaLinearLayout)meta;
		layout.setOrientation(json.optInt(JSONConstants.LAYOUT_ORIENTATION));
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaLinearLayout();
	}

}
