package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaTimerTask;

public class MetaTimerTaskJSONHandler extends MetaBaseScriptJSONHandler<MetaTimerTask,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaTimerTask meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.TIMERTASK_DELAY, meta.getDelay());
		JSONHelper.writeToJSON(json, JSONConstants.TIMERTASK_REPEAT, meta.isRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.TIMERTASK_PERIOD, meta.getPeriod());
		JSONHelper.writeToJSON(json, JSONConstants.TIMERTASK_STARTONLOAD, meta.startOnload());
		JSONHelper.writeToJSON(json, JSONConstants.TIMERTASK_THROWEXCEPTION, meta.isThrowException());
	}
	
	@Override
	public void fromJSONImpl(MetaTimerTask meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setDelay(json.optInt(JSONConstants.TIMERTASK_DELAY));
		meta.setRepeat(json.optBoolean(JSONConstants.TIMERTASK_REPEAT));
		meta.setPeriod(json.optInt(JSONConstants.TIMERTASK_PERIOD));
		meta.setStartOnload(json.optBoolean(JSONConstants.TIMERTASK_STARTONLOAD));
		meta.setThrowException(json.optBoolean(JSONConstants.TIMERTASK_THROWEXCEPTION));
	}
	
	@Override
	public MetaTimerTask newInstance() {
		return new MetaTimerTask();
	}

}
