package com.bokesoft.yes.meta.json.form;

import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.form.component.view.MetaComponentView;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaColumnLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaCustomLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexBox;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableViewLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaWizardLayout;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaBaseComponentOverrides;

public class MetaComponentViewJSONHandler extends AbstractJSONHandler<MetaComponentView,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaComponentView meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		
		MetaBaseComponentOverrides overrides = meta.getOverrides();
		if( overrides != null ) {
			JSONObject o = UIJSONHandlerUtil.build(overrides,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_OVERRIDES, o);
		}
		
		JSONArray array = UIJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	@SuppressWarnings("unchecked")
	public void fromJSONImpl(MetaComponentView meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_OVERRIDES);
		if( o != null ) {
			MetaBaseComponentOverrides overrides = UIJSONHandlerUtil.unbuild(MetaBaseComponentOverrides.class, json);
			meta.setOverrides(overrides);
		}
		
		// 每个对象可能不一样,根据类型反序列化
		o = json.optJSONObject(JSONConstants.COMMON_ITEMS);
		if( o != null ) {
			Set<String> set = o.keySet();
			for( String key : set ) {
				meta.add(unbuild(o.optJSONObject(key)));
			}
		}
		
		// 布局子项反序列化
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			for( int i = 0,size = array.length();i < size; i++ ) {
				meta.add(unbuild(array.optJSONObject(i)));
			}
		}
	}
	
	@Override
	public MetaComponentView newInstance() {
		return new MetaComponentView();
	}
	
	private MetaComponentLayout<?> unbuild(JSONObject o) throws Throwable {
		MetaComponentLayout<?> layout = null;
		int layoutType = o.optInt(JSONConstants.COMMON_TYPE);
		switch (layoutType) {
		case LayoutType.LAYOUT_BORDER:
			layout = UIJSONHandlerUtil.unbuild(MetaBorderLayout.class, o);
			break;
		case LayoutType.LAYOUT_COLUMN:
			layout = UIJSONHandlerUtil.unbuild(MetaColumnLayout.class, o);
			break;
		case LayoutType.LAYOUT_CUSTOM:
			layout = UIJSONHandlerUtil.unbuild(MetaCustomLayout.class, o);
			break;	
		case LayoutType.LAYOUT_FLEXBOX:
			layout = UIJSONHandlerUtil.unbuild(MetaFlexBox.class, o);
			break;
		case LayoutType.LAYOUT_FLEXFLOW:
			layout = UIJSONHandlerUtil.unbuild(MetaFlexFlowLayout.class, o);
			break;
		case LayoutType.LAYOUT_FLOW:
			layout = UIJSONHandlerUtil.unbuild(MetaFlowLayout.class, o);
			break;
		case LayoutType.LAYOUT_FLUIDTABLE:
			layout = UIJSONHandlerUtil.unbuild(MetaFluidTableLayout.class, o);
			break;
		case LayoutType.LAYOUT_GRID:
			layout = UIJSONHandlerUtil.unbuild(MetaGridLayout.class, o);
			break;
		case LayoutType.LAYOUT_LINEAR:
			layout = UIJSONHandlerUtil.unbuild(MetaLinearLayout.class, o);
			break;
		case LayoutType.LAYOUT_SPLIT:
			layout = UIJSONHandlerUtil.unbuild(MetaSplitLayout.class, o);
			break;
		case LayoutType.LAYOUT_TAB:
			layout = UIJSONHandlerUtil.unbuild(MetaTabLayout.class, o);
			break;
		case LayoutType.LAYOUT_TABLE:
			layout = UIJSONHandlerUtil.unbuild(MetaTableLayout.class, o);
			break;
		case LayoutType.LAYOUT_TABLEVIEW:
			layout = UIJSONHandlerUtil.unbuild(MetaTableViewLayout.class, o);
			break;
		case LayoutType.LAYOUT_WIZARD:
			layout = UIJSONHandlerUtil.unbuild(MetaWizardLayout.class, o);
			break;
		default:
			break;
		}
		return layout;
	}

}
