package com.bokesoft.yes.meta.json.form;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRowIndex;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutWizardItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableRowLayout;

public abstract class MetaComponentLayoutJSONHandler extends AbstractJSONHandler<MetaComponentLayout<? extends MetaLayoutItem>,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getLayoutType()); // 反序列化确定类型
		// 布局子项序列化
		JSONArray array = UIJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
		MetaFormat format = meta.getFormat();
		if( format != null ) {
			JSONObject o = UIJSONHandlerUtil.build(format,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PANDDING, meta.getPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTPANDDING, meta.getLeftPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTPADDING, meta.getRightPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPPADDING, meta.getTopPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMPADDING, meta.getBottomPadding());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_MARGIN, meta.getMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTMARGIN, meta.getLeftMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTMARGIN, meta.getRightMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMMARGIN, meta.getBottomMargin());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERCOLOR, meta.getBorderColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERRADIUS, meta.getBorderRadius());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERWIDTH, meta.getBorderWidth());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERSTYLE, meta.getBorderStyle());
	}

	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		
		// 布局子项反序列化
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			for( int i = 0,size = array.length();i < size; i++ ) {
				JSONObject childJSON = array.optJSONObject(i);
				String tagName = childJSON.optString(JSONConstants.COMMON_TAGNAME);
				meta.add(UIJSONHandlerUtil.unbuild(clazz(tagName), childJSON));
			}
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if( o != null ) {
			MetaFormat format = UIJSONHandlerUtil.unbuild(MetaFormat.class, o);
			meta.setFormat(format);
		}
		
		meta.setPadding(json.optString(JSONConstants.COMMON_PANDDING));
		meta.setLeftPadding(json.optString(JSONConstants.COMMON_LEFTPANDDING));
		meta.setRightPadding(json.optString(JSONConstants.COMMON_RIGHTPADDING));
		meta.setTopPadding(json.optString(JSONConstants.COMMON_TOPPADDING));
		meta.setBottomPadding(json.optString(JSONConstants.COMMON_BOTTOMPADDING));
		
		meta.setMargin(json.optString(JSONConstants.COMMON_MARGIN));
		meta.setLeftMargin(json.optString(JSONConstants.COMMON_LEFTMARGIN));
		meta.setRightMargin(json.optString(JSONConstants.COMMON_RIGHTMARGIN));
		meta.setTopMargin(json.optString(JSONConstants.COMMON_TOPMARGIN));
		meta.setBottomMargin(json.optString(JSONConstants.COMMON_BOTTOMMARGIN));
		
		meta.setBorderColor(json.optString(JSONConstants.COMPONENT_BORDERCOLOR));
		meta.setBorderRadius(json.optString(JSONConstants.COMPONENT_BORDERRADIUS));
		meta.setBorderWidth(json.optString(JSONConstants.COMPONENT_BORDERWIDTH));
		meta.setBorderStyle(json.optString(JSONConstants.COMPONENT_BORDERSTYLE));
	}
	
	public Class<? extends MetaLayoutItem> clazz(String tagName) {
		Class<? extends MetaLayoutItem> clazz = null;
		switch (tagName) {
		case MetaLayoutDirection.TAG_NAME:
			clazz = MetaLayoutDirection.class;
			break;
		case MetaLayoutFlowIndex.TAG_NAME:
			clazz = MetaLayoutFlowIndex.class;
			break;
		case MetaLayoutRowIndex.TAG_NAME:
			clazz = MetaLayoutRowIndex.class;
			break;
		case MetaLayoutSpan.TAG_NAME:
			clazz = MetaLayoutSpan.class;
			break;
		case MetaLayoutSplitItem.TAG_NAME:
			clazz = MetaLayoutSplitItem.class;
			break;
		case MetaLayoutTabItem.TAG_NAME:
			clazz = MetaLayoutTabItem.class;
			break;
		case MetaLayoutWizardItem.TAG_NAME:
			clazz = MetaLayoutWizardItem.class;
			break;
		case MetaLinearItem.TAG_NAME:
			clazz = MetaLinearItem.class;
			break;
		case MetaTableRowLayout.TAG_NAME:
			clazz = MetaTableRowLayout.class;
			break;
		default:
			break;
		}
		return clazz;
	}
	
}
