package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;

public class MetaVideoPlayerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaVideoPlayerProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaVideoPlayerProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.VIDEOPLAYER_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.VIDEOPLAYER_PATH, meta.getPath());
		JSONHelper.writeToJSON(json, JSONConstants.VIDEOPLAYER_UPLOADPROGRESS, meta.getUploadProgress());
	}

	@Override
	public void fromJSONImpl(MetaVideoPlayerProperties meta, JSONObject json) throws Throwable {
		meta.setSourceType(json.optInt(JSONConstants.VIDEOPLAYER_SOURCETYPE));
		meta.setPath(json.optString(JSONConstants.VIDEOPLAYER_PATH));
		meta.setUploadProgress(json.optInt(JSONConstants.VIDEOPLAYER_UPLOADPROGRESS));
	}

	@Override
	public MetaVideoPlayerProperties newInstance() {
		return new MetaVideoPlayerProperties();
	}
}
