package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;

public class MetaPriceLabelPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaPriceLabelProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaPriceLabelProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PRICELABEL_PRETEXT, meta.getPreText());
		JSONHelper.writeToJSON(json, JSONConstants.PRICELABEL_DECIMALDIGITS, meta.getDecimalDigits());
		JSONHelper.writeToJSON(json, JSONConstants.PRICELABEL_SHOWTHOUSANDTH, meta.getShowThousandth());

		MetaPriceLabelItemCollection collection = meta.getItemCollection();
		if (collection != null) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, collection);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		}
	}

	@Override
	public void fromJSONImpl(MetaPriceLabelProperties meta, JSONObject json) throws Throwable {
		meta.setPreText(json.optString(JSONConstants.PRICELABEL_PRETEXT));
		meta.setDecimalDigits(json.optInt(JSONConstants.PRICELABEL_DECIMALDIGITS, 2));
		meta.setShowThousandth(json.optBoolean(JSONConstants.PRICELABEL_SHOWTHOUSANDTH, true));

		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if (array != null) {
			MetaPriceLabelItemCollection collection = new MetaPriceLabelItemCollection();
			List<MetaPriceLabelItem> list = UIJSONHandlerUtil.unbuild(MetaPriceLabelItem.class, array);
			collection.addAll(0, list);
			meta.setItemCollection(collection);
		}
	}

	@Override
	public MetaPriceLabelProperties newInstance() {
		return new MetaPriceLabelProperties();
	}

}
