package com.bokesoft.yes.meta.json.com.properties;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictPaneProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

public class MetaDictPanePropertiesJSONHandler extends BasePropertiesJSONHandler<MetaDictPaneProperties> {
	
	@Override
	public void fromJSONImpl(MetaDictPaneProperties meta, JSONObject json) throws Throwable {
		meta.setItemKey(json.optString(JSONConstants.DICT_ITEMKEY));
		meta.setDynamic(json.optBoolean(JSONConstants.DICT_ISDYNAMIC));
		meta.setCompDict(json.optBoolean(JSONConstants.DICT_ISCOMPDICT));
		meta.setRoot(json.optString(JSONConstants.DICT_ROOT));
		meta.setAllowMultiSelection(json.optBoolean(JSONConstants.DICT_MULTISELECT));
		meta.setRefKey(json.optString(JSONConstants.DICT_REFKEY));
		meta.setIndependent(json.optBoolean(JSONConstants.DICT_INDEPENDENT));
		meta.setStateMask(json.optInt(JSONConstants.DICT_STATEMASK));
		meta.setItemKeySource(json.optString(JSONConstants.DICT_ITEMKEYSOURCE));
		meta.setItemKeySourceType(json.optInt(JSONConstants.DICT_ITEMKEYSOURCETYPE));
		meta.setIgnoreRights(json.optBoolean(JSONConstants.DICT_IGNORERIGHTS));
		meta.setEditable(json.optBoolean(JSONConstants.DICT_EDITABLE));
		meta.setEditType(json.optInt(JSONConstants.DICT_EDITTYPE));
		meta.setShowType(json.optInt(JSONConstants.DICTPANE_SHOWTYPE));
		meta.setLoadType(json.optInt(JSONConstants.DICT_LOADTYPE));
		meta.setFormulaText(json.optString(JSONConstants.DICT_FORMULATEXT));
		meta.setTextField(json.optString(JSONConstants.DICT_TEXTFIELD));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setPromptData(json.optBoolean(JSONConstants.DICT_PROMPTDATA));
		meta.setQueryMatchType(json.optInt(JSONConstants.DICT_QUERYMATCHTYPE));
		
		JSONObject o = json.optJSONObject(JSONConstants.DICT_ITEMFILTERS);
		if( o != null ) {
			MetaItemFilterCollection filterCollection = UIJSONHandlerUtil.unbuild(MetaItemFilterCollection.class, o);
			meta.setFilters(filterCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDictPaneProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEY,  meta.getItemKey());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ISDYNAMIC, meta.isDynamic());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ISCOMPDICT, meta.isCompDict());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ROOT, meta.getRoot());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_MULTISELECT, meta.isAllowMultiSelection());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_REFKEY, meta.getRefKey());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_INDEPENDENT, meta.isIndependent());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_STATEMASK, meta.getStateMask());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEYSOURCE, meta.getItemKeySource());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEYSOURCETYPE, meta.getItemKeySourceType());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_IGNORERIGHTS, meta.isIgnoreRights());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_EDITABLE, meta.isEditable());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_EDITTYPE, meta.getEditType());
		JSONHelper.writeToJSON(json, JSONConstants.DICTPANE_SHOWTYPE, meta.getShowType());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_LOADTYPE, meta.getLoadType());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_FORMULATEXT, meta.getFormulaText());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_TEXTFIELD, meta.getTextField());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_PROMPTDATA, meta.isPromptData());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_QUERYMATCHTYPE, meta.getQueryMatchType());
		
		MetaItemFilterCollection filters = meta.getFilters();
		if( filters != null ) {
			JSONObject o = UIJSONHandlerUtil.build(filters,hook);
			JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMFILTERS, o);
			
			// 额外属性
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, hook.getFormKey());
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FIELDKEY, key);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, String.join(",", getDepends(meta)));
	}
	
	protected List<String> getDepends(MetaDictPaneProperties meta) {
		List<String> depends = new ArrayList<>();
		String root = meta.getRoot();
		if(root != null && !root.isEmpty()) {
			depends.add(root);
		}
		return depends;
	}

	@Override
	public MetaDictPaneProperties newInstance() {
		return new MetaDictPaneProperties();
	}

}

