package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBPMGraphProperties;

public class MetaBPMGraphPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaBPMGraphProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaBPMGraphProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OID, meta.getOID());
		JSONHelper.writeToJSON(json, JSONConstants.BPMGRAPH_PROCESSPATH, meta.getProcessPath());
		JSONHelper.writeToJSON(json, JSONConstants.BPMGRAPH_PROCESSKEY, meta.getProcessKey());
		JSONHelper.writeToJSON(json, JSONConstants.BPMGRAPH_PROCESSVER, meta.getProcessVer());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.BPMGRAPH_VIEWTAG, meta.getViewTag());
	}
	
	@Override
	public void fromJSONImpl(MetaBPMGraphProperties meta, JSONObject json) throws Throwable {
		meta.setOID(json.optString(JSONConstants.COMMON_OID));
		meta.setProcessPath(json.optString(JSONConstants.BPMGRAPH_PROCESSPATH));
		meta.setProcessKey(json.optString(JSONConstants.BPMGRAPH_PROCESSKEY));
		meta.setProcessVer(json.optString(JSONConstants.BPMGRAPH_PROCESSVER));
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setViewTag(json.optString(JSONConstants.BPMGRAPH_VIEWTAG));
	}

	@Override
	public MetaBPMGraphProperties newInstance() {
		return new MetaBPMGraphProperties();
	}
}
