package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaWaterFall;

public class MetaWaterFallJSONHandler extends MetaListViewJSONHandler<MetaWaterFall> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaWaterFall meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.WATERFALL_COUNT, meta.getCount());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_CELLGAP, meta.getCellGap());
	}
	
	@Override
	public void fromJSONImpl(MetaWaterFall meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCount(json.optInt(JSONConstants.WATERFALL_COUNT));
		meta.setRowGap(json.optInt(JSONConstants.TILEDLIST_ROWGAP));
		meta.setCellGap(json.optInt(JSONConstants.TILEDLIST_CELLGAP));
	}
	
	@Override
	public MetaWaterFall newInstance() {
		return new MetaWaterFall();
	}
}
