package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemList;

public class MetaWizardItemListJSONHandler extends AbstractJSONHandler<MetaWizardItemList,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaWizardItemList meta, JSONObject json) throws Throwable {
		meta.setTableKey(json.optString(JSONConstants.WIZARDITEMLIST_TABLEKEY));
		meta.setSourceType(json.optInt(JSONConstants.WIZARDITEMLIST_SOURCETYPE));
		
		String s = json.optString(JSONConstants.WIZARDITEMLIST_FORMULAITEMS);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			script.setContent(s);
			meta.setFormulaItems(script);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaWizardItemList meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEMLIST_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEMLIST_SOURCETYPE, meta.getSourceType());
		
		MetaBaseScript formulaItems = meta.getFormulaItems();
		if( formulaItems != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEMLIST_FORMULAITEMS, formulaItems.getContent().trim());
		}
	}

	@Override
	public MetaWizardItemList newInstance() {
		return new MetaWizardItemList();
	}
}
