package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.form.component.control.MetaValidateBox;

public class MetaValidateBoxJSONHandler extends BaseComponentJSONHandler<MetaValidateBox>{

	@Override
	public MetaValidateBox newInstance() {
		return new MetaValidateBox();
	}
	
	@Override
	public void fromJSONImpl(MetaValidateBox meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		Object o = json.opt(JSONConstants.VALIDATEBOX_DISABLEKEYBOARD);
		if(o != null) {
			meta.setDisableKeyboard(Boolean.parseBoolean(o.toString()));
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaValidateBox meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		String promptText = hook.getString(GroupKeyTable.STR_PROMPT, "", meta.getKey(), meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, promptText);
		JSONHelper.writeToJSON(json, JSONConstants.VALIDATEBOX_DISABLEKEYBOARD, meta.isDisableKeyboard());
	}
}
