package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.MetaCustom;

public class MetaCustomJSONHandler extends BaseComponentJSONHandler<MetaCustom> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCustom meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_IMPL, meta.getImpl());
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_USERDATA, meta.getUserData());
		
	}
	
	@Override
	public void fromJSONImpl(MetaCustom meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setImpl(json.optString(JSONConstants.CUSTOM_IMPL));
		meta.setTag(json.optString(JSONConstants.CUSTOM_TAG));
		meta.setUserData(json.optString(JSONConstants.CUSTOM_USERDATA));
	}

	@Override
	public MetaCustom newInstance() {
		return new MetaCustom();
	}
	
}