package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartTemplate;

public class MetaChartTemplateJSONHandler extends AbstractJSONHandler<MetaChartTemplate,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaChartTemplate meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.CHART_TEMPLATE_OPTION, meta.getOption().trim());
	}

	@Override
	public MetaChartTemplate newInstance() {
		return new MetaChartTemplate();
	}

	@Override
	public void fromJSONImpl(MetaChartTemplate meta, JSONObject json) throws Throwable {
		meta.setOption(json.optString(JSONConstants.CHART_TEMPLATE_OPTION));
	}


}
