package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.timer.action.TimerSeDevClass;

public class TimerSeDevClassJSONHandler extends AbstractJSONHandler<TimerSeDevClass, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(TimerSeDevClass meta, JSONObject json) throws Throwable {
		meta.setClassPath(json.optString(JSONConstants.TIMER_CLASS_PATH));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, TimerSeDevClass meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_CLASS_PATH, meta.getClassPath());
		
	}
	
	@Override
	public TimerSeDevClass newInstance() {
		return new TimerSeDevClass();
	}
}
