package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;

public class MetaStateActionJSONHandler extends MetaNodeJSONHandler<MetaStateAction> {

	@Override
	public void fromJSONImpl(MetaStateAction meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setDenyNodeKey(json.optString(JSONConstants.NODE_DENY_NODE_KEY));
		
		JSONObject o = json.optJSONObject(JSONConstants.BPM_BPMOPERATION);
		if(o != null){
			MetaBPMOperation operation = BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, o);
			meta.setOperation(operation);
		}
		o = json.optJSONObject(JSONConstants.BPM_BATCHOPERATION);
		if(o != null){
			MetaBPMOperation batchOperation = BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, o);
			meta.setBatchOperation(batchOperation);
		}
		o = json.optJSONObject(JSONConstants.STATE_NODE);
		if(o != null){
			MetaState stateNode = BPMJSONHandlerUtil.unbuild(MetaState.class, o);
			meta.setStateNode(stateNode);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_PARTICIPATORCOLLECTION);
		if(array != null){
			MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaDictionary.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
				}else if(MetaMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
				}else if(MetaQuery.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
				}else if(MetaRelation.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
				}else if(MetaExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
				}
			}
			meta.setParticipatorCollection(participatorCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaStateAction meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_DENY_NODE_KEY, meta.getDenyNodeKey());
		
		MetaBPMOperation operation = meta.getOperation();
		if(operation != null){
			JSONObject o = BPMJSONHandlerUtil.build(operation, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_BPMOPERATION, o);
		}
		MetaBPMOperation batchOperation = meta.getBatchOperation();
		if(batchOperation != null){
			JSONObject o = BPMJSONHandlerUtil.build(batchOperation, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_BATCHOPERATION, o);
		}
		MetaState stateNode = meta.getStateNode();
		if(stateNode != null){
			JSONObject o = BPMJSONHandlerUtil.build(stateNode, hook);
			JSONHelper.writeToJSON(json, JSONConstants.STATE_NODE, o);
		}
		
		MetaParticipatorCollection participatorCollection = meta.getParticipatorCollection();
		if(participatorCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, participatorCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PARTICIPATORCOLLECTION, array);
		}
	}
	
	@Override
	public MetaStateAction newInstance() {
		return new MetaStateAction();
	}
}
