package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNode;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNodeCollection;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaRelationJSONHandler extends AbstractJSONHandler<MetaRelation, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaRelation meta, JSONObject json) throws Throwable {
		String s = json.optString(JSONConstants.RELATION_FORMULA);
		if(s.length() > 0){
			MetaBaseScript script = new MetaBaseScript(BPMConstants.RELATION_FORMULA);
			script.setContent(s);
			meta.setScript(script);
		}
		JSONArray array = json.optJSONArray(JSONConstants.BPM_RELATIONNODECOLLECTION);
		if(array != null){
			MetaRelationNodeCollection nodecollection = new MetaRelationNodeCollection();
			nodecollection.addAll(BPMJSONHandlerUtil.unbuild(MetaRelationNode.class, array));
			meta.setNodecollection(nodecollection);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRelation meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		MetaBaseScript script = meta.getScript();
		if(script != null){
			JSONHelper.writeToJSON(json, JSONConstants.RELATION_FORMULA, script.getContent().trim());
		}
		MetaRelationNodeCollection nodecollection = meta.getNodeCollection();
		if(nodecollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, nodecollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_RELATIONNODECOLLECTION, array);
		}
		
	}
	
	@Override
	public MetaRelation newInstance() {
		return new MetaRelation();
	}
}
