package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameter;

public class MetaQueryParameterJSONHandler extends AbstractJSONHandler<MetaQueryParameter, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaQueryParameter meta, JSONObject json) throws Throwable {
		meta.setDataType(json.optInt(JSONConstants.COMMON_DATATYPE));
		meta.setFormula(json.optString(JSONConstants.FORMPARA_FORMULA));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaQueryParameter meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_FORMULA, meta.getFormula());
		
	}
	
	
	@Override
	public MetaQueryParameter newInstance() {
		return new MetaQueryParameter();
	}
}
