package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiAudit;

public class MetaMultiAuditJSONHandler extends MetaAuditJSONHandler<MetaMultiAudit> {

	@Override
	public void fromJSONImpl(MetaMultiAudit meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setInOrder(json.optBoolean(JSONConstants.NODE_IN_ORDER));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMultiAudit meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.NODE_IN_ORDER, meta.isInOrder());
	}
	
	@Override
	public MetaMultiAudit newInstance() {
		return new MetaMultiAudit();
	}
}
