package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;

public class MetaMidFormulaJSONHandler extends AbstractJSONHandler<MetaMidFormula, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaMidFormula meta, JSONObject json) throws Throwable {
		meta.setFormula(json.optString(JSONConstants.BPM_FORMULA));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMidFormula meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_FORMULA, meta.getFormula());
		
	}
	
	@Override
	public MetaMidFormula newInstance() {
		return new MetaMidFormula();
	}
}
