package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMField;

public class MetaDMFieldJSONHandler extends AbstractJSONHandler<MetaDMField, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaDMField meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setSourceFieldKey(json.optString(JSONConstants.DATA_MIGRATION_SOURCE));
		meta.setType(json.optInt(JSONConstants.DATA_MIGRATION_TYPE));
		meta.setConstValue(json.optString(JSONConstants.DATA_MIGRATION_CONSTVALUE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDMField meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATA_MIGRATION_SOURCE, meta.getSourceFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATA_MIGRATION_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.DATA_MIGRATION_CONSTVALUE, meta.getConstValue());
		
	}
	
	@Override
	public MetaDMField newInstance() {
		return new MetaDMField();
	}
}
