package com.bokesoft.yes.meta.json;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationItem;

public class MetaNavigationItemJSONHandler extends AbstractJSONHandler<MetaNavigationItem,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ITEM_ENTRYKEY, meta.getEntryKey());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ITEM_ENTRYFILTER, meta.isEntryFilter());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_IMAGESCALETYPE, meta.getImageScaleType());
		JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, meta.getOnclick());
	}

	@Override
	public void fromJSONImpl(MetaNavigationItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setEntryKey(json.optString(JSONConstants.NAVIGATIONLIST_ITEM_ENTRYKEY));
		if(json.has(JSONConstants.NAVIGATIONLIST_ITEM_ENTRYFILTER)){
			meta.setEntryFilter(json.optBoolean(JSONConstants.NAVIGATIONLIST_ITEM_ENTRYFILTER));
		}
		meta.setImageScaleType(json.optInt(JSONConstants.NAVIGATIONLIST_IMAGESCALETYPE));
		meta.setOnclick(json.optString(JSONConstants.Event_OnClick));
	}

	@Override
	public MetaNavigationItem newInstance() {
		return new MetaNavigationItem();
	}

}
