/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSplitButtonProperties;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaSplitButtonPropertiesJSONHandler
extends BasePropertiesJSONHandler<MetaSplitButtonProperties> {
    @Override
    public void fromJSONImpl(MetaSplitButtonProperties meta, JSONObject json) throws Throwable {
        JSONArray array;
        meta.setIcon(json.optString("icon"));
        String s = json.optString("onClick");
        if (s != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("OnClick");
            script.setContent(s);
            meta.setOnClick(script);
        }
        if ((array = json.optJSONArray("items")) != null) {
            MetaDropdownItemCollection collection = this.unbuild(array);
            meta.setItemCollection(collection);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaSplitButtonProperties meta, DefaultSerializeContext hook, String key) throws Throwable {
        MetaBaseScript onClick;
        JSONHelper.writeToJSON((JSONObject)json, (String)"icon", (Object)meta.getIcon());
        MetaDropdownItemCollection collection = meta.getItemCollection();
        if (collection != null) {
            JSONArray array = this.buildItems(key, collection, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)array);
        }
        if ((onClick = meta.getOnClick()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"onClick", (Object)onClick.getContent());
        }
    }

    private JSONArray buildItems(String key, MetaDropdownItemCollection collection, DefaultSerializeContext hook) throws Throwable {
        JSONArray array = new JSONArray();
        Iterator it = collection.iterator();
        MetaDropdownItem item = null;
        while (it.hasNext()) {
            item = (MetaDropdownItem)it.next();
            JSONObject o = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)o, (String)"key", (Object)item.getKey());
            String text = hook.getString("Items", key, "Item-" + item.getKey(), item.getText());
            JSONHelper.writeToJSON((JSONObject)o, (String)"text", (Object)text);
            JSONHelper.writeToJSON((JSONObject)o, (String)"separator", (Object)item.getSeparator());
            MetaBaseScript onClick = item.getOnClick();
            if (onClick != null) {
                JSONHelper.writeToJSON((JSONObject)o, (String)"formula", (Object)onClick.getContent().trim());
            }
            array.put((Object)o);
        }
        return array;
    }

    private MetaDropdownItemCollection unbuild(JSONArray array) {
        MetaDropdownItemCollection collection = new MetaDropdownItemCollection();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject o = array.optJSONObject(i);
            MetaDropdownItem item = new MetaDropdownItem();
            item.setKey(o.optString("key"));
            item.setText(o.optString("text"));
            item.setSeparator(o.optBoolean("separator"));
            String s = o.optString("formula");
            if (s != null && !s.isEmpty()) {
                MetaBaseScript script = new MetaBaseScript("OnClick");
                script.setContent(s);
                item.setOnClick(script);
            }
            collection.add((AbstractMetaObject)item);
        }
        return collection;
    }

    @Override
    public MetaSplitButtonProperties newInstance() {
        return new MetaSplitButtonProperties();
    }
}

