/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.layout;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.meta.solution.MetaLang;
import org.json.JSONObject;

public class MetaGridLayoutJSONHandler
extends MetaComponentLayoutJSONHandler {
    @Override
    public void toJSONImpl(JSONObject json, MetaComponentLayout<? extends MetaLayoutItem> meta, DefaultSerializeContext hook) throws Throwable {
        MetaColumnDefCollection columnDefCollection;
        super.toJSONImpl(json, meta, hook);
        MetaGridLayout layout = (MetaGridLayout)meta;
        MetaRowDefCollection rowDefCollection = layout.getRowDefCollection();
        if (rowDefCollection != null) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)rowDefCollection, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"rows", (Object)o);
        }
        if ((columnDefCollection = layout.getColumnDefCollection()) != null) {
            String locale = hook.getVE().getEnv().getLocale();
            MetaColumnDefCollection cloneColumnDef = (MetaColumnDefCollection)columnDefCollection.clone();
            if (!"zh-CN".equals(locale)) {
                int xIndex = 0;
                for (MetaColumnDef metaColumnDef : cloneColumnDef.getList()) {
                    DefSize width = metaColumnDef.getWidth();
                    if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getZhCHT_Width()) && "zh-CHT".equals(locale)) {
                        width = metaColumnDef.getZhCHT_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getEnUS_Width()) && "en-US".equals(locale)) {
                        width = metaColumnDef.getEnUS_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getRuRU_Width()) && "ru-RU".equals(locale)) {
                        width = metaColumnDef.getRuRU_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getJaJP_Width()) && "ja-JP".equals(locale)) {
                        width = metaColumnDef.getJaJP_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getFrFR_Width()) && "fr-FR".equals(locale)) {
                        width = metaColumnDef.getFrFR_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getEsES_Width()) && "es-ES".equals(locale)) {
                        width = metaColumnDef.getEsES_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getPtPT_Width()) && "pt-PT".equals(locale)) {
                        width = metaColumnDef.getPtPT_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getDeDE_Width()) && "de-DE".equals(locale)) {
                        width = metaColumnDef.getDeDE_Width();
                    } else if (!StringUtil.isBlankOrNull((Object)metaColumnDef.getArAE_Width()) && "ar-AE".equals(locale)) {
                        width = metaColumnDef.getArAE_Width();
                    } else {
                        int sizeType = width.getSizeType();
                        for (MetaLayoutSpan item : layout.items()) {
                            MetaComponent metaComponent;
                            int size = width.getSize();
                            int itemX = item.getX();
                            if (xIndex != itemX || 1 == sizeType || 209 != (metaComponent = (MetaComponent)hook.getMetaForm().getComponentMap().get((Object)item.getKey())).getControlType()) continue;
                            MetaLang metaLang = (MetaLang)MetaFactory.getGlobalInstance().getSolution().getLangConfig().get(locale);
                            float widthMultiple = Float.parseFloat(metaLang.getWidthMultiple());
                            size = (int)((float)size * widthMultiple);
                            width = new DefSize(sizeType, size);
                            break;
                        }
                    }
                    metaColumnDef.setWidth(width);
                    ++xIndex;
                }
            }
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)cloneColumnDef, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"columns", (Object)o);
        }
    }

    @Override
    public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
        super.fromJSONImpl(meta, json);
        MetaGridLayout layout = (MetaGridLayout)meta;
        JSONObject o = json.optJSONObject("rows");
        if (o != null) {
            MetaRowDefCollection rowDefCollection = UIJSONHandlerUtil.unbuild(MetaRowDefCollection.class, o);
            layout.setRowDefCollection(rowDefCollection);
        }
        if ((o = json.optJSONObject("columns")) != null) {
            MetaColumnDefCollection columnDefCollection = UIJSONHandlerUtil.unbuild(MetaColumnDefCollection.class, o);
            layout.setColumnDefCollection(columnDefCollection);
        }
    }

    @Override
    public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
        return new MetaGridLayout();
    }
}

