/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.form;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.anim.MetaAnimProperty;
import com.bokesoft.yigo.meta.form.anim.MetaAnimPropertyCollection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaAnimItemJSONHandler
extends AbstractJSONHandler<MetaAnimItem, DefaultSerializeContext> {
    @Override
    public void fromJSONImpl(MetaAnimItem meta, JSONObject json) throws Throwable {
        meta.setKey(json.optString("key"));
        meta.setType(json.optInt("type"));
        meta.setDuration(json.optLong("duration"));
        meta.setMaxDuration(json.optLong("maxDuration"));
        meta.setRepeatMode(json.optInt("repeatMode"));
        meta.setStartOffset(json.optLong("startOffset"));
        String s = json.optString("repeatCount");
        if (s != null && !s.isEmpty()) {
            meta.setRepeatCount(Integer.valueOf(s));
        }
        if ((s = json.optString("fillBefore")) != null && !s.isEmpty()) {
            meta.setFillBefore(Boolean.valueOf(s));
        }
        if ((s = json.optString("fillAfter")) != null && !s.isEmpty()) {
            meta.setFillAfter(Boolean.valueOf(s));
        }
        meta.setInterpolator(json.optInt("interpolator"));
        meta.setDelay(Float.parseFloat(json.optString("delay")));
        meta.setOrder(json.optInt("order"));
        JSONArray array = json.optJSONArray("properties");
        if (array != null) {
            MetaAnimPropertyCollection collection = new MetaAnimPropertyCollection();
            List<MetaAnimProperty> list = UIJSONHandlerUtil.unbuild(MetaAnimProperty.class, array);
            collection.addAll(list);
            meta.setProperties(collection);
        }
        if ((array = json.optJSONArray("items")) != null) {
            List<MetaAnimItem> list = UIJSONHandlerUtil.unbuild(MetaAnimItem.class, array);
            meta.addAll(0, list);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaAnimItem meta, DefaultSerializeContext hook) throws Throwable {
        Boolean fillBefore;
        Boolean fillAfter;
        JSONHelper.writeToJSON((JSONObject)json, (String)"key", (Object)meta.getKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"type", (Object)meta.getType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"duration", (Object)meta.getDuration());
        JSONHelper.writeToJSON((JSONObject)json, (String)"maxDuration", (Object)meta.getMaxDuration());
        JSONHelper.writeToJSON((JSONObject)json, (String)"repeatMode", (Object)meta.getRepeatMode());
        JSONHelper.writeToJSON((JSONObject)json, (String)"startOffset", (Object)meta.getStartOffset());
        Integer repeatCount = meta.getRepeatCount();
        if (repeatCount != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"repeatCount", (Object)meta.getRepeatCount());
        }
        if ((fillAfter = meta.getFillAfter()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"fillAfter", (Object)fillAfter);
        }
        if ((fillBefore = meta.getFillBefore()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"fillBefore", (Object)fillBefore);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"interpolator", (Object)meta.getInterpolator());
        JSONHelper.writeToJSON((JSONObject)json, (String)"delay", (Object)(meta.getDelay() + ""));
        JSONHelper.writeToJSON((JSONObject)json, (String)"order", (Object)meta.getOrder());
        MetaAnimPropertyCollection properties = meta.getProperties();
        if (properties != null) {
            JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)properties);
            JSONHelper.writeToJSON((JSONObject)json, (String)"properties", (Object)array);
        }
        JSONArray items = new JSONArray();
        for (MetaAnimItem item : meta) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)item, hook);
            items.put((Object)o);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)items);
    }

    @Override
    public MetaAnimItem newInstance() {
        return new MetaAnimItem();
    }
}

