/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.other;

import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaEntryJSONHandler
extends AbstractJSONHandler<MetaEntry, SolutionSerializeContext> {
    @Override
    public void toJSONImpl(JSONObject json, MetaEntry meta, SolutionSerializeContext hook) throws Throwable {
    }

    @Override
    public MetaEntry newInstance() {
        return new MetaEntry();
    }

    @Override
    public void fromJSONImpl(MetaEntry meta, JSONObject json) throws Throwable {
        JSONObject object = json.optJSONObject("entry");
        meta.setStyle(object.optInt("style"));
        JSONArray array = object.optJSONArray("children");
        if (array != null) {
            this.unbuildEntry(meta, array);
        }
    }

    private void unbuildEntry(MetaEntry parent, JSONArray array) {
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject o = array.optJSONObject(i);
            int type = o.optInt("objectType");
            if (type == 1) {
                this.unbuildEntry(parent, o);
                continue;
            }
            this.unbuildEntryItem(parent, o);
        }
    }

    private void unbuildEntry(MetaEntry parent, JSONObject json) {
        MetaEntry entry = new MetaEntry();
        entry.setKey(json.optString("key"));
        entry.setCaption(json.optString("name"));
        entry.setIcon(json.optString("icon"));
        entry.setOpen(json.optBoolean("open"));
        entry.setVisible(json.optString("visible"));
        entry.setPath(json.optString("path"));
        entry.setProject(json.optString("project"));
        entry.setStyle(json.optInt("style"));
        MetaBaseScript onClick = new MetaBaseScript("OnClick");
        onClick.setContent(json.optString("onClick"));
        entry.setOnClick(onClick);
        JSONArray array = json.optJSONArray("children");
        if (array != null) {
            this.unbuildEntry(entry, array);
        }
        parent.add((AbstractCompositeObject)entry);
    }

    private void unbuildEntryItem(MetaEntry parent, JSONObject json) {
        MetaEntryItem item = new MetaEntryItem();
        item.setKey(json.optString("key"));
        item.setCaption(json.optString("name"));
        item.setIcon(json.optString("icon"));
        item.setFormKey(json.optString("formKey"));
        item.setEnable(json.optString("enable"));
        item.setVisible(json.optString("visible"));
        item.setShortKeys(json.optString("shortCuts"));
        item.setType(json.optInt("type"));
        item.setParameters(json.optString("parameters"));
        item.setSingle(json.optBoolean("single"));
        item.setTarget(json.optInt("target"));
        item.setPath(json.optString("path"));
        MetaBaseScript action = new MetaBaseScript("Action");
        action.setContent(json.optString("action"));
        item.setAction(action);
        MetaBaseScript onClick = new MetaBaseScript("OnClick");
        onClick.setContent(json.optString("onClick"));
        item.setOnClick(onClick);
        parent.add((AbstractCompositeObject)item);
    }
}

