/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.form;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaOperationCollectionJSONHandler
extends AbstractJSONHandler<MetaOperationCollection, DefaultSerializeContext> {
    @Override
    public void fromJSONImpl(MetaOperationCollection meta, JSONObject json) throws Throwable {
        meta.setKey(json.optString("key"));
        meta.setCaption(json.optString("caption"));
        meta.setVisible(json.optString("visibleCnt"));
        meta.setVisibleDependency(json.optString("visibleDependency"));
        meta.setEnable(json.optString("enableCnt"));
        meta.setEnableDependency(json.optString("enableDependency"));
        String s = json.optString("action");
        if (s != null) {
            MetaBaseScript action = new MetaBaseScript("Action");
            action.setContent(s);
            meta.setAction(action);
        }
        meta.setIcon(json.optString("icon"));
        meta.setSelfDisable(Boolean.valueOf(json.optBoolean("selfDisable")));
        meta.setCssClass(json.optString("cssClass"));
        JSONArray array = json.optJSONArray("items");
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject subOptObj = array.getJSONObject(i);
            if (subOptObj.has("items")) {
                meta.add((KeyPairCompositeObject)UIJSONHandlerUtil.unbuild(MetaOperationCollection.class, subOptObj));
                continue;
            }
            meta.add((KeyPairCompositeObject)UIJSONHandlerUtil.unbuild(MetaOperation.class, subOptObj));
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaOperationCollection meta, DefaultSerializeContext hook) throws Throwable {
        JSONHelper.writeToJSON((JSONObject)json, (String)"key", (Object)meta.getKey());
        String caption = hook.getString("Opt", "", meta.getKey(), meta.getCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)caption);
        JSONHelper.writeToJSON((JSONObject)json, (String)"visibleCnt", (Object)meta.getVisible());
        JSONHelper.writeToJSON((JSONObject)json, (String)"visibleDependency", (Object)meta.getVisibleDependency());
        JSONHelper.writeToJSON((JSONObject)json, (String)"enableCnt", (Object)meta.getEnable());
        JSONHelper.writeToJSON((JSONObject)json, (String)"enableDependency", (Object)meta.getEnableDependency());
        MetaBaseScript action = meta.getAction();
        if (action != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"action", (Object)action.getContent().trim());
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"icon", (Object)meta.getIcon());
        JSONHelper.writeToJSON((JSONObject)json, (String)"selfDisable", (Object)meta.isSelfDisable());
        JSONHelper.writeToJSON((JSONObject)json, (String)"cssClass", (Object)meta.getCssClass());
        JSONArray array = new JSONArray();
        Iterator it = meta.iterator();
        while (it.hasNext()) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)it.next(), hook);
            array.put((Object)o);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)array);
    }

    @Override
    public MetaOperationCollection newInstance() {
        return new MetaOperationCollection();
    }
}

