package com.bokesoft.yes.meta.json.soluton;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.commondef.MetaStatus;

public class MetaStatusJSONHandler extends AbstractJSONHandler<MetaStatus,ISerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaStatus meta, ISerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.STATUS_STANDALONE, meta.isStandalone());
	}

	@Override
	public MetaStatus newInstance() {
		return new MetaStatus();
	}

	@Override
	public void fromJSONImpl(MetaStatus meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setValue(json.optInt(JSONConstants.COMMON_VALUE));
		meta.setStandalone(json.optBoolean(JSONConstants.STATUS_STANDALONE));
	}

}
