package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;
import com.bokesoft.yigo.meta.report.embed.MetaReportText;

public class MetaReportTextJSONHandler extends AbstractJSONHandler<MetaReportText,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportText meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_Y, meta.getY());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FIELDKEY, meta.getFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FORMULA, meta.getFormula());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMPL, meta.getImpl());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FILLEMPTYCONTENT, meta.isFillEmptyContent());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGENO, meta.getPageNo());
		
		MetaReportDisplay display = meta.getDisplay();
		if( display != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(display, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_DISPLAY, o);
		}
	}

	@Override
	public MetaReportText newInstance() {
		return new MetaReportText();
	}

	@Override
	public void fromJSONImpl(MetaReportText meta, JSONObject json) throws Throwable {
		meta.setX(json.optInt(JSONConstants.COMPONENT_X));
		meta.setY(json.optInt(JSONConstants.COMPONENT_Y));
		meta.setWidth(json.optInt(JSONConstants.COMMON_WIDTH));
		meta.setHeight(json.optInt(JSONConstants.COMMON_HEIGHT));
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setSourceType(json.optInt(JSONConstants.REPORT_SOURCETYPE));
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setFieldKey(json.optString(JSONConstants.COMMON_FIELDKEY));
		meta.setFormula(json.optString(JSONConstants.REPORT_FORMULA));
		meta.setImpl(json.optString(JSONConstants.REPORT_IMPL));
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setForeColor(json.optString(JSONConstants.COMMON_FORECOLOR));
		meta.setFillEmptyContent(json.optBoolean(JSONConstants.REPORT_FILLEMPTYCONTENT));
		meta.setPageNo(json.optInt(JSONConstants.REPORT_PAGENO));
		
		JSONObject o = json.optJSONObject(JSONConstants.REPORT_DISPLAY);
		if( o != null ) {
			MetaReportDisplay display = (MetaReportDisplay) ReportJSONHandlerUtil.unbuild(o);
			meta.setDisplay(display);
		}
		
	}

}
