package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportGridColumn;

public class MetaReportGridColumnJSONHandler extends AbstractJSONHandler<MetaReportGridColumn,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportGridColumn meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_EXPANDKEY, meta.getExpandKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_LOCK, meta.isLock());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_NEEDDETERMINEROWWRAP, meta.isNeedDetermineRowWrap());
	}

	@Override
	public MetaReportGridColumn newInstance() {
		return new MetaReportGridColumn();
	}

	@Override
	public void fromJSONImpl(MetaReportGridColumn meta, JSONObject json) throws Throwable {
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setWidth(json.optInt(JSONConstants.COMMON_WIDTH));
		meta.setExpandKey(json.optString(JSONConstants.REPORT_EXPANDKEY));
		meta.setLock(json.optBoolean(JSONConstants.REPORT_LOCK));
		meta.setNeedDetermineRowWrap(json.getBoolean(JSONConstants.REPORT_NEEDDETERMINEROWWRAP));
	}

}
