package com.bokesoft.yes.meta.json.other;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;

public class MetaEntryJSONHandler extends AbstractJSONHandler<MetaEntry, SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaEntry meta, SolutionSerializeContext hook) throws Throwable {
		// see GetEntryCmd
	}

	@Override
	public MetaEntry newInstance() {
		return new MetaEntry();
	}

	@Override
	public void fromJSONImpl(MetaEntry meta, JSONObject json) throws Throwable {
		JSONObject object = json.optJSONObject(JSONConstants.ENTRY);
		meta.setStyle(object.optInt(JSONConstants.ENTRY_STYLE));
		
		JSONArray array = object.optJSONArray(JSONConstants.ENTRY_CHILDREN);
		if( array != null ) {
			unbuildEntry(meta, array);		
		}
	}
	
	private void unbuildEntry(MetaEntry parent,JSONArray array) {
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			int type = o.optInt(JSONConstants.COMMON_OBJECTTYPE);
			if( type == MetaEntryItem.ENTRY ) {
				unbuildEntry(parent, o);
			} else {
				unbuildEntryItem(parent, o);
			}
		}
	}
	
	private void unbuildEntry(MetaEntry parent,JSONObject json) {
		MetaEntry entry = new MetaEntry();
		entry.setKey(json.optString(JSONConstants.COMMON_KEY));
		entry.setCaption(json.optString(JSONConstants.COMMON_NAME));
		entry.setIcon(json.optString(JSONConstants.ENTRY_ICON));
		entry.setOpen(json.optBoolean(JSONConstants.ENTRY_OPEN));
		entry.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		entry.setPath(json.optString(JSONConstants.ENTRY_PATH));
		entry.setProject(json.optString(JSONConstants.ENTRY_PROJECT));
		entry.setStyle(json.optInt(JSONConstants.ENTRY_STYLE));
		
		MetaBaseScript onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
		onClick.setContent(json.optString(JSONConstants.Event_OnClick));
		entry.setOnClick(onClick);
		
		JSONArray array = json.optJSONArray(JSONConstants.ENTRY_CHILDREN);
		if( array != null ) {
			unbuildEntry(entry, array);		
		}
		parent.add(entry);
	}
	
	private void unbuildEntryItem(MetaEntry parent,JSONObject json) {
		MetaEntryItem item = new MetaEntryItem();
		item.setKey(json.optString(JSONConstants.COMMON_KEY));
		item.setCaption(json.optString(JSONConstants.COMMON_NAME));
		item.setIcon(json.optString(JSONConstants.ENTRY_ICON));
		item.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		item.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
		item.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		item.setShortKeys(json.optString(JSONConstants.ENTRY_SHORTCUTS));
		item.setType(json.optInt(JSONConstants.COMMON_TYPE));
		item.setParameters(json.optString(JSONConstants.ENTRY_PARAMETERS));
		item.setSingle(json.optBoolean(JSONConstants.ENTRY_SINGLE));
		item.setTarget(json.optInt(JSONConstants.COMMON_TARGET));
		item.setPath(json.optString(JSONConstants.ENTRY_PATH));
		
		MetaBaseScript action = new MetaBaseScript(MetaConstants.Event_Action);
		action.setContent(json.optString(JSONConstants.Event_Action));
		item.setAction(action);
		
		MetaBaseScript onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
		onClick.setContent(json.optString(JSONConstants.Event_OnClick));
		item.setOnClick(onClick);
		
		parent.add(item);
	}

}
