package com.bokesoft.yes.meta.json.mobiledef;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDef;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDefCollection;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClass;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClassCollection;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundItem;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundPool;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorDef;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorItem;

public class MetaMobileDefJSONHandler extends AbstractJSONHandler<MetaMobileDef,SolutionSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaMobileDef meta, JSONObject json) throws Throwable {
		meta.setCss(json.optString(JSONConstants.MOBILEDEF_CSS));
		meta.setHasNavigationBar(json.optString(JSONConstants.MOBILEDEF_HASNAVIGATIONBAR));
		meta.setSysLanguage(json.optBoolean(JSONConstants.MOBILEDEF_SYSLANGUAGE));
		meta.setPassEnableTime(json.optInt(JSONConstants.MOBILEDEF_PASSENABLETIME));
		meta.setPassErrorCount(json.optInt(JSONConstants.MOBILEDEF_PASSERRORCOUNT));
		Object fullScreenType = json.opt(JSONConstants.FORM_FULLSCREENTYPE);
		if(fullScreenType != null){
			meta.setFullscreenType(Integer.parseInt(fullScreenType.toString()));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.MOBILEDEF_NAVIGATIONBAR);
		if( o != null ) {
			MetaNavigationBar bar = UIJSONHandlerUtil.unbuild(MetaNavigationBar.class, o);
			meta.setNavigationBar(bar);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.MOBILEDEF_EVENTDEFCOLLECTION);
		if( array != null ) {
			MetaEventDefCollection collection = new MetaEventDefCollection();
			List<MetaEventDef> list = UIJSONHandlerUtil.unbuild(MetaEventDef.class, array);
			collection.addAll(list);
			meta.setEventDefCollection(collection);
		}
		
		array = json.optJSONArray(JSONConstants.MOBILEDEF_VIBRATORDEF);
		if( array != null ) {
			MetaVibratorDef vibratorDef = new MetaVibratorDef();
			List<MetaVibratorItem> list = UIJSONHandlerUtil.unbuild(MetaVibratorItem.class, array);
			vibratorDef.addAll(list);
			meta.setVibratorDef(vibratorDef);
		}
		
		array = json.optJSONArray(JSONConstants.MOBILEDEF_SOUNDPOOL);
		if( array != null ) {
			MetaSoundPool soundPool = new MetaSoundPool();
			List<MetaSoundItem> list = UIJSONHandlerUtil.unbuild(MetaSoundItem.class, array);
			soundPool.addAll(list);
			meta.setSoundPool(soundPool);
		}
		
		array = json.optJSONArray(JSONConstants.MOBILEDEF_EXTCLASSCOLLECTION);
		if( array != null ) {
			MetaExtClassCollection collection = new MetaExtClassCollection();
			List<MetaExtClass> list = UIJSONHandlerUtil.unbuild(MetaExtClass.class, array);
			collection.addAll(list);
			meta.setExtClassCollection(collection);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaMobileDef meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_CSS, meta.getCss());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_HASNAVIGATIONBAR, meta.getHasNavigationBar());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_SYSLANGUAGE, meta.isSysLanguage());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PASSENABLETIME, meta.getPassEnableTime());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PASSERRORCOUNT, meta.getPassErrorCount());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_FULLSCREENTYPE, meta.getFullscreenType());
		
		MetaNavigationBar navigationBar = meta.getNavigationBar();
		if( navigationBar != null ) {
			JSONObject o = UIJSONHandlerUtil.build(navigationBar,hook);
			JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_NAVIGATIONBAR, o);
		}
		
		MetaEventDefCollection collection = meta.getEventDefCollection();
		if( collection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, collection);
			JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_EVENTDEFCOLLECTION, array);
		}
		
		MetaVibratorDef vibratorDef = meta.getVibratorDef();
		if( vibratorDef != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, vibratorDef);
			JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_VIBRATORDEF, array);
		}
		
		MetaSoundPool soundPool = meta.getSoundPool();
		if( soundPool != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, soundPool);
			JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_SOUNDPOOL, array);
		}
		
		MetaExtClassCollection extClassCollection = meta.getExtClassCollection();
		if( extClassCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, extClassCollection);
			JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_EXTCLASSCOLLECTION, array);
		}
		
	}

	@Override
	public MetaMobileDef newInstance() {
		return new MetaMobileDef();
	}
	
}
