package com.bokesoft.yes.meta.json.mobiledef;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDef;

public class MetaEventDefJSONHandler extends AbstractJSONHandler<MetaEventDef,SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaEventDef meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
	}

	@Override
	public void fromJSONImpl(MetaEventDef meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
	}

	@Override
	public MetaEventDef newInstance() {
		return new MetaEventDef();
	}

}
