package com.bokesoft.yes.meta.json.layout;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollapaseTypeEnum;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;

public class MetaSplitLayoutJSONHandler extends MetaComponentLayoutJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaSplitLayout layout = (MetaSplitLayout) meta;
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_ORIENTATION, layout.getOrientation());
		
		Iterator<MetaLayoutSplitItem> it = layout.iterator();
		MetaLayoutSplitItem item = null;
		JSONArray splitSizes = new JSONArray();
		JSONObject size = null;
		while (it.hasNext()) {
			item = it.next();
			size = new JSONObject();
			DefSize defSize = item.getSize();
			if(defSize != null){
				if (defSize.getSizeType() == DefSize.Fix) {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.getSize(), 0);
				} else if (defSize.getSizeType() == DefSize.Ratio) {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.toString(), "0");
				} else {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.toString(), "");
				}
			}
			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_FORWARD_COLLAPASED, item.getForwardCollapased(), false);
			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_REVERSE_COLLAPASED, item.getReverseCollapased(), false);
			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_TYPE, MetaSplitSizeCollapaseTypeEnum.getNameByType(item.getType()), "None");
			size.put(JSONConstants.SPLITSIZE_LOCK, false);
			splitSizes.put(size);
		}
		if (splitSizes.length() > 0) {
			json.put(JSONConstants.SPLITPANEL_SPLITSIZES, splitSizes);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaSplitLayout layout = (MetaSplitLayout)meta;
		layout.setOrientation(json.optInt(JSONConstants.LAYOUT_ORIENTATION));
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaSplitLayout();
	}

}
