package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutWizardItem;

public class MetaLayoutWizardItemJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutWizardItem> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutWizardItem meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutWizardItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
	}
	
	@Override
	public MetaLayoutWizardItem newInstance() {
		return new MetaLayoutWizardItem();
	}
}
