package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;

public class MetaLayoutTabItemJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutTabItem> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutTabItem meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutTabItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
	}
	
	@Override
	public MetaLayoutTabItem newInstance() {
		return new MetaLayoutTabItem();
	}
}
