package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.anim.MetaAnimProperty;

public class MetaAnimPropertyJSONHandler extends AbstractJSONHandler<MetaAnimProperty,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaAnimProperty meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
	}

	@Override
	public void fromJSONImpl(MetaAnimProperty meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
	}

	@Override
	public MetaAnimProperty newInstance() {
		// TODO Auto-generated method stub
		return new MetaAnimProperty();
	}

}
