package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;

public class MetaUploadButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaUploadButtonProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaUploadButtonProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_MAXSIZE, meta.getMaxSize());
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_ALLOWEDTYPES, meta.getAllowedTypes());
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_DELETEOLD, meta.isDeleteOld());
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_ISMULTIFILE, meta.isMultiFile());
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_POSTPROCESS, meta.getPostProcess());
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_PROVIDER, meta.getProvider());
		
		MetaBaseScript finishEvent = meta.getFinishEvent();
		if(finishEvent != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FinishedEvent, finishEvent.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaUploadButtonProperties meta, JSONObject json) throws Throwable {
		meta.setMaxSize(json.optInt(JSONConstants.UPLOADBUTTON_MAXSIZE));
		meta.setAllowedTypes(json.optString(JSONConstants.UPLOADBUTTON_ALLOWEDTYPES));
		meta.setDeleteOld(json.optBoolean(JSONConstants.UPLOADBUTTON_DELETEOLD));
		meta.setMultiFile(json.optBoolean(JSONConstants.UPLOADBUTTON_ISMULTIFILE));
		meta.setPostProcess(json.optString(JSONConstants.UPLOADBUTTON_POSTPROCESS));
		meta.setProvider(json.optString(JSONConstants.UPLOADBUTTON_PROVIDER));
		
		String s = json.optString(JSONConstants.Event_FinishedEvent);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FinishedEvent);
			script.setContent(s);
			meta.setFinishEvent(script);
		}		
	}

	@Override
	public MetaUploadButtonProperties newInstance() {
		return new MetaUploadButtonProperties();
	}

}
