package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFlatCanvasProperties;

public class MetaFlatCanvasPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaFlatCanvasProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaFlatCanvasProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.FLATCANVAS_SOURCE, meta.getSource());
	}

	@Override
	public void fromJSONImpl(MetaFlatCanvasProperties meta, JSONObject json) throws Throwable {
		meta.setSource(json.optString(JSONConstants.FLATCANVAS_SOURCE));
	}

	@Override
	public MetaFlatCanvasProperties newInstance() {
		return new MetaFlatCanvasProperties();
	}
	
}
