package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;

public class MetaDynamicDictPropertiesJSONHandler extends MetaDictPropertiesJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDictProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		super.toJSONImpl(json, meta, hook, key);
		
		JSONHelper.writeToJSON(json, JSONConstants.DICT_REFKEY, meta.getRefKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, String.join(",", getDepends(meta)));
	}
	
	@Override
	protected List<String> getDepends(MetaDictProperties meta) {
		List<String> depends = super.getDepends(meta);
		String refKey = meta.getRefKey();
		if( refKey != null && !refKey.isEmpty() ) {
			depends.add(refKey);
		}
		return depends;
	}
	
	@Override
	public void fromJSONImpl(MetaDictProperties meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setRefKey(json.optString(JSONConstants.DICT_REFKEY));
	}
	
}
