package com.bokesoft.yes.meta.json.com.properties;

import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.util.MetaUtil;

public class MetaCheckListBoxPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaCheckListBoxProperties> {
	
	@Override
	public void fromJSONImpl(MetaCheckListBoxProperties meta, JSONObject json) throws Throwable {
		meta.setItemsDependency(json.optString(JSONConstants.COMBOBOX_ITEMS_DEPENDENCY));
		meta.setGroupKey(json.optString(JSONConstants.COMBOBOX_GROUPKEY));
		meta.setGlobalItems(json.optString(JSONConstants.COMBOBOX_GLOBALITEMS));
		meta.setCache(json.optBoolean(JSONConstants.COMBOBOX_NEEDCACHE));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setStyle(json.optInt(JSONConstants.COMBOBOX_STYLE));
		meta.setEditType(json.optInt(JSONConstants.COMBOBOX_EDITTYPE));
		meta.setColumnCount(json.optInt(JSONConstants.COMBOBOX_COLUMNCOUNT));
		meta.setPopAnim(json.optString(JSONConstants.COMMON_POPANIM));
		meta.setSourceType(json.optInt(JSONConstants.COMBOBOX_SOURCETYPE));
		meta.setGlobalItems(json.optString(JSONConstants.COMBOBOX_GLOBALITEMS));
		meta.setSourceType(json.optInt(JSONConstants.COMBOBOX_SOURCETYPE));
		
		String s = json.optString(JSONConstants.COMBOBOX_FORMULA);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			script.setContent(s);
			meta.setFormulaItems(script);
		}
		
		int sourceType = meta.getSourceType();
		if( sourceType == ComboBoxSourceType.ITEMS 
				|| sourceType == ComboBoxSourceType.STATUS 
				|| sourceType == ComboBoxSourceType.PARAGROUP) {
			JSONArray array = json.optJSONArray(JSONConstants.COMBOBOX_ITEMS); 
			if( array != null ) {
				MetaListBoxItemCollection metaItems = new MetaListBoxItemCollection();
				List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
				metaItems.addAll(0, list);
				meta.setItems(metaItems);
			}
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMBOBOX_QUERYDEF);
		if( o != null ) {
			MetaQueryDef queryDef = UIJSONHandlerUtil.unbuild(MetaQueryDef.class, o);
			meta.setQueryDef(queryDef);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCheckListBoxProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_ITEMS_DEPENDENCY, String.join(",", meta.getDependedFields()));
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_GROUPKEY, meta.getGroupKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_GLOBALITEMS, meta.getGlobalItems());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_NEEDCACHE, meta.getCache(), false);
		String promptText = hook.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, promptText);
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_EDITTYPE, meta.getEditType());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_POPANIM, meta.getPopAnim());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_GLOBALITEMS, meta.getGlobalItems());
		
		MetaBaseScript formulaItems = meta.getFormulaItems();
		if( formulaItems != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_FORMULA, formulaItems.getContent().trim());
		}
		
		JSONArray array = null;
		switch(meta.getSourceType()){
		case ComboBoxSourceType.ITEMS:
			MetaListBoxItemCollection metaItems = meta.getItems();
			if( metaItems != null ) {
				array = buildCommonItems(key, hook, metaItems);					
			}
		break;
		case ComboBoxSourceType.STATUS: 
			MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(hook.getVE().getMetaFactory(),hook.getMetaForm());
			if( statusCollection != null ) {
				array = buildStatusItems(hook, statusCollection);
			}
		break;
		case ComboBoxSourceType.PARAGROUP: 
			MetaParaGroup metaParaGroup = MetaUtil.getParaGroup(hook.getVE().getMetaFactory(),hook.getMetaForm(),meta.getGroupKey());
			if( metaParaGroup != null ) {
				array = buildGroupItems(hook, metaParaGroup);
			}
		break;
		}
	
		if( array != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_ITEMS, array);
		}
		
		MetaQueryDef queryDef = meta.getQueryDef();
		if( queryDef != null ) {
			JSONObject o = UIJSONHandlerUtil.build(queryDef,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_QUERYDEF, o);
		}
		
		// 添加依赖
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, String.join(",", meta.getDependedFields()));
	}
	
	private JSONArray buildCommonItems(String key, DefaultSerializeContext hook, MetaListBoxItemCollection metaItems) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaDefaultItem> it = metaItems.iterator();
		while ( it.hasNext() ) {
			MetaDefaultItem metaItem = it.next();
			JSONObject itemJSON = new JSONObject();
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaItem.getKey());
			
			String text = hook.getString(GroupKeyTable.STR_ITEMS, key, "Item-"+metaItem.getKey(), metaItem.getCaption());
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, text);
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaItem.getValue());
			array.put(itemJSON);
		}
		return array;
	}
	
	private JSONArray buildStatusItems(DefaultSerializeContext hook, MetaStatusCollection statusCollection) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaStatus> it = statusCollection.iterator();
		MetaStatus metaStatus = null;
		String caption = null;
		while (it.hasNext()) {
			metaStatus = it.next();
			JSONObject itemJSON = new JSONObject();
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaStatus.getKey());
			
			caption = hook.getString(GroupKeyTable.STR_STATUS, "", metaStatus.getKey(), metaStatus.getCaption());
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, caption);
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaStatus.getValue());
			array.put(itemJSON);
		}
		return array;
	}
	
	private JSONArray buildGroupItems(DefaultSerializeContext hook,MetaParaGroup metaGroup) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaParaItem> it = metaGroup.iterator();
		while (it.hasNext()) {
			MetaParaItem metaParaItem = it.next();
			JSONObject paraJSON = new JSONObject();
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_KEY, metaParaItem.getKey());
			
			String caption = hook.getString(GroupKeyTable.STR_PARAS, metaGroup.getKey(), metaParaItem.getKey(), metaParaItem.getCaption());
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_CAPTION, caption);
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_VALUE, metaParaItem.getValue());
			array.put(paraJSON);
		}
		return array;
	}

	@Override
	public MetaCheckListBoxProperties newInstance() {
		
		return new MetaCheckListBoxProperties();
	}
}
