package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.PropertiesJSONHandlerMap;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCellFormat;

public class MetaGridCellJSONHandler extends AbstractJSONHandler<MetaGridCell,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaGridCell meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setCellType(json.optInt(JSONConstants.GRID_CELLTYPE));
		meta.setTableKey(json.optString(JSONConstants.GRID_TABLEKEY));
		meta.setAccessControl(json.optBoolean(JSONConstants.GRID_ACCESSCONTROL));
		meta.setSelect(json.optBoolean(JSONConstants.GRID_ISSELECT));
		meta.setSingleSelect(json.optBoolean(JSONConstants.GRID_SINGLESELECT));
		meta.setToolTip(json.optString(JSONConstants.GRID_TIP));
		meta.setIsMerged(json.optBoolean(JSONConstants.GRID_ISMERGED));
		meta.setIsMergedHead(json.optBoolean(JSONConstants.GRID_ISMERGEDHEAD));
		meta.setMergedRowSpan(json.optInt(JSONConstants.GRID_ROWSPAN));
		meta.setMergedColumnSpan(json.optInt(JSONConstants.GRID_COLSPAN));
		meta.setCellGroupType(json.optInt(JSONConstants.GRID_CELLGROUPTYPE));
		meta.setEnable(json.optString(JSONConstants.GRID_ENABLE));
		meta.setEnableDependency(json.optString(JSONConstants.GRID_ENABLEDEPENDENCY));
		
		String s = json.optString(JSONConstants.GRID_CELLDBLCLICK);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_CellDblClick);
			script.setContent(s);
			meta.setDblClick(script);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.GRID_COLUMNEXPAND);
		if( o != null ) {
			MetaColumnExpand columnExpand = UIJSONHandlerUtil.unbuild(MetaColumnExpand.class, o);
			meta.setColumnExpand(columnExpand);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.GRID_DIMVALUE);
		if( array != null ) {
			MultiDimValue dimValue = new MultiDimValue();
			dimValue.fromJSONArray(array);
			meta.setDimValue(dimValue);
		}
		
		o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if( o != null ) {
			MetaGridCellFormat format = UIJSONHandlerUtil.unbuild(MetaGridCellFormat.class, o);
			meta.setFormat(format);
		}
		
		o = json.optJSONObject(JSONConstants.COMPONENT_DATABINDING);
		if( o != null ) {
			MetaDataBinding dataBinding = UIJSONHandlerUtil.unbuild(MetaDataBinding.class, o);
			meta.setDataBinding(dataBinding);
		}
		
		o = json.optJSONObject(JSONConstants.GRID_EDITOPTIONS);
		BasePropertiesJSONHandler<AbstractMetaObject> propertesbuilder = PropertiesJSONHandlerMap.getBuilder(meta.getCellType());
		if( o != null && propertesbuilder != null ) {
			AbstractMetaObject properties = propertesbuilder.fromJSON(o);
			meta.setProperties(properties);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaGridCell meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String caption = hook.getString(GroupKeyTable.STR_CELL, "", meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLTYPE, meta.getCellType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ACCESSCONTROL, meta.isAccessControl());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_VALUECHANGED, meta.getValueChanged());
		JSONHelper.writeToJSON(json, "valueChangeAction", meta.getValueChangeAction());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DEFAULTVALUE, meta.getDefaultValue());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISSELECT, meta.isSelect());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SINGLESELECT, meta.singleSelect());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TIP, meta.getToolTip());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISMERGED, meta.isMerged());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISMERGEDHEAD, meta.isMergedHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWSPAN, meta.getMergedRowSpan());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLSPAN, meta.getMergedColumnSpan());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUECHANGED, meta.getValueChanged());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASDB, meta.hasDataBinding());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISREQUIRED, meta.isRequired());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ENABLE, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ENABLEDEPENDENCY, meta.getEnableDependency());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_MERGE, meta.isMerge());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_MERGEGROUP, meta.isMergeGroup());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLGROUPTYPE, meta.getCellGroupType());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_EXTENDJSON, meta.getExtendJson());

		// 双击事件
		MetaBaseScript dblClick = meta.getDblClick();
		if( dblClick != null && !dblClick.isEmpty() ) {
			JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLDBLCLICK, dblClick.getContent().trim());
		}
		
		// 单元格拓展
		MetaColumnExpand columnExpand = meta.getColumnExpand();
		if (columnExpand != null) {
			JSONObject o = UIJSONHandlerUtil.build(columnExpand,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNEXPAND, o);
		}
		
		// 维度数据
		MultiDimValue dimValue = meta.getDimValue();
		if( dimValue != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.GRID_DIMVALUE, dimValue.toJSONArray());
		}
		
		MetaDataBinding dataBinding = meta.getDataBinding();
		if( dataBinding != null ) {
			JSONObject o = UIJSONHandlerUtil.build(dataBinding,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_DATABINDING, o);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ALWAYSSHOW, MetaGridCell.isAlwaysShow(meta.getCellType()));
		
		AbstractMetaObject properties = meta.getProperties();
		BasePropertiesJSONHandler<AbstractMetaObject> propertesbuilder = PropertiesJSONHandlerMap.getBuilder(meta.getCellType());
		if( properties != null && propertesbuilder != null ) {
			JSONObject o = propertesbuilder.toJSON(properties, hook, meta.getKey());
			
			JSONHelper.writeToJSON(o, JSONConstants.COMMON_KEY, meta.getKey());
			JSONHelper.writeToJSON(o, JSONConstants.GRID_CELLTYPE, meta.getCellType());
			
			JSONHelper.writeToJSON(json, JSONConstants.GRID_EDITOPTIONS, o); // properties
		}
		
		MetaGridCellFormat format = meta.getFormat();
		if( format != null ) {
			JSONObject o = UIJSONHandlerUtil.build(format,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
		}
		
		// 访问控制
		if( meta.hasDataBinding() ) {
			JSONHelper.writeToJSON(json, JSONConstants.ACCESS_CONTROL, meta.isAccessControl());				
		}
		
		// 数据源默认值
		JSONHelper.writeToJSON(json, JSONConstants.DS_DEFAULTVALUE, meta.getDsDefaultValue());
	}

	@Override
	public MetaGridCell newInstance() {
		return new MetaGridCell();
	}

}