package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;

public class MetaTableRowJSONHandler extends BaseComponentJSONHandler<MetaTableRow> {
	
	@Override
	public void fromJSONImpl(MetaTableRow meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTopMargin(json.optString(JSONConstants.COMMON_TOPMARGIN));
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setRowType(json.optInt(JSONConstants.TABLEVIEW_ROWTYPE));
		meta.setTableKey(json.optString(JSONConstants.TABLEVIEW_TABLEKEY));
		meta.setStyle(json.optInt(JSONConstants.TABLEVIEW_STYLE));
		meta.setColumnCount(json.optInt(JSONConstants.TABLEVIEW_COLUMNCOUNT));
		meta.setGroupColumnKeys(json.optString(JSONConstants.TABLEVIEW_GROUPCOLUMNKEYS));
		meta.setSeparatorStyle(json.optString(JSONConstants.TABLEVIEW_SEPARATORSTYLE));
		meta.setSeparatorRadius(json.optInt(JSONConstants.TABLEVIEW_SEPARATORRADIUS));
		meta.setSeparatorColor(json.optString(JSONConstants.TABLEVIEW_SEPARATORCOLOR));
		meta.setShowFirstMargin(json.optBoolean(JSONConstants.TABLEVIEW_SHOWFIRSTMARGIN));
		meta.setSelectColor(json.optString(JSONConstants.TABLEVIEW_SELECTCOLOR));
		meta.setHighlightColor(json.optString(JSONConstants.TABLEVIEW_HIGHLIGHTCOLOR));
		meta.setIndicator(json.optBoolean(JSONConstants.TABLEVIEW_INDICATOR));
		meta.setHoverHead(json.optBoolean(JSONConstants.TABLEVIEW_HOVERHEAD));
		meta.setIndicatorKey(json.optString(JSONConstants.TABLEVIEW_INDICATORKEY));
		meta.setGroupCollapse(json.optBoolean(JSONConstants.TABLEVIEW_GROUPCOLLAPSE));
		meta.setPromptImage(json.optString(JSONConstants.TABLEVIEW_PROMPTIMAGE));
		meta.setPromptRowCount(json.optInt(JSONConstants.TABLEVIEW_PROMPTROWCOUNT));
		meta.setPageRowCount(json.optInt(JSONConstants.TABLEVIEW_PAGEROWCOUNT));
		meta.setPageLoadType(json.optInt(JSONConstants.TABLEVIEW_PAGELOADTYPE));
		
		String s = json.optString(JSONConstants.TABLEVIEW_SEPARATOROFFSET);
		if (s != null && !s.isEmpty()) {
			meta.setSeparatorOffset(DefSize.parse(s));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
		
		s = json.optString(JSONConstants.Event_RowClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}
		
		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}
		
		s = json.optString(JSONConstants.Event_RowDblClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}
		
		s = json.optString(JSONConstants.Event_OnCollapse);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnCollapse);
			script.setContent(s);
			meta.setOnCollapse(script);
		}
		
		s = json.optString(JSONConstants.Event_OnExpand);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnExpand);
			script.setContent(s);
			meta.setOnExpand(script);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION);
		if( array != null ) {
			MetaRowActionCollection collection = new MetaRowActionCollection();
			List<MetaRowAction> list = UIJSONHandlerUtil.unbuild(MetaRowAction.class, array);
			collection.addAll(list);
			meta.setActionCollection(collection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTableRow meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_ROWTYPE, meta.getRowType());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_GROUPCOLUMNKEYS, meta.getGroupColumnKeys());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORSTYLE, meta.getSeparatorStyle());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORRADIUS, meta.getSeparatorRadius());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATORCOLOR, meta.getSeparatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SHOWFIRSTMARGIN, meta.isShowFirstMargin());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SELECTCOLOR, meta.getSelectColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_HIGHLIGHTCOLOR, meta.getHighlightColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_INDICATOR, meta.isIndicator());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_HOVERHEAD, meta.isHoverHead());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_INDICATORKEY, meta.getIndicatorKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_GROUPCOLLAPSE, meta.isGroupCollapse());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_PROMPTIMAGE, meta.getPromptImage());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_PROMPTROWCOUNT, meta.getPromptRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_PAGEROWCOUNT, meta.getPageRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_PAGELOADTYPE, meta.getPageLoadType());
		
		DefSize offset = meta.getSeparatorOffset();
		if( offset != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_SEPARATOROFFSET, offset.toString(), "");			
		}
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}

		MetaBaseScript click = (MetaBaseScript) meta.getRowClick();
		if( click != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, click.getContent().trim());
		}

		MetaBaseScript dbClick = meta.getRowDblClick();
		if( dbClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}

		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if( rowChange != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}
		
		MetaBaseScript onCollapse = meta.getOnCollapse();
		if( onCollapse != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnCollapse, onCollapse.getContent().trim());
		}
		
		MetaBaseScript onExpand = meta.getOnExpand();
		if( onExpand != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnExpand, onExpand.getContent().trim());
		}

		MetaRowActionCollection collection = meta.getActionCollection();
		if( collection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, collection);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION, array);
		}

	}

	@Override
	public MetaTableRow newInstance() {
		return new MetaTableRow();
	}
}
