package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;

public class MetaRadioButtonJSONHandler extends BaseComponentJSONHandler<MetaRadioButton> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRadioButton meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_GROUPKEY, meta.getGroupKey());
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_METAVALUE, meta.getSelectedValue());
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_ISGROUPHEAD, meta.isGroupHead());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ICONLOCATION, meta.getIconLocation());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_HIDEBUTTON, meta.getIsHideButton());
	}
	
	@Override
	public void fromJSONImpl(MetaRadioButton meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setGroupKey(json.optString(JSONConstants.RADIOBUTTON_GROUPKEY));
		meta.setSelectedValue(json.optString(JSONConstants.RADIOBUTTON_METAVALUE));
		meta.setGroupHead(json.optBoolean(JSONConstants.RADIOBUTTON_ISGROUPHEAD));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setSelectedIcon(json.optString(JSONConstants.CHECKBOX_SELECTEDICON));
		meta.setIconLocation(json.optInt(JSONConstants.CHECKBOX_ICONLOCATION));
		meta.setHideButton(json.optBoolean(JSONConstants.CHECKBOX_HIDEBUTTON));
	}

	@Override
	public MetaRadioButton newInstance() {
		return new MetaRadioButton();
	}
	
}
