package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGroup;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaHandle;

public class MetaGroupJSONHandler extends AbstractJSONHandler<MetaGroup, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGroup meta, DefaultSerializeContext hook) throws Throwable {
		json.put(JSONConstants.COMMON_KEY, meta.getKey());
		json.put(JSONConstants.COMMON_CAPTION, meta.getCaption());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_EXPANDED, meta.getExpanded());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_START_ROW, meta.getStartRow());
		json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_END_ROW, meta.getEndRow());
		MetaHandle metaHandle = meta.getMetaHandle();
		if (metaHandle != null) {
			JSONObject o = UIJSONHandlerUtil.build(metaHandle, hook);
			json.put(JSONConstants.GRIDLAYOUTPANEL_GROUP_HANDLE, o);
		}
	}

	@Override
	public MetaGroup newInstance() {
		return new MetaGroup();
	}

	@Override
	public void fromJSONImpl(MetaGroup meta, JSONObject json) throws Throwable {
		// TODO Auto-generated method stub
		
	}

}

